package com.ejie.ab04b.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.stereotype.Component;

/**
 * 
 * @author GFI-NORTE
 * 
 */
@Component(value = "applicationProperties")
public class PropertiesUtil extends PropertyPlaceholderConfigurer {

	/** properties **/

	// simulacion entorno
	public static final String SIMULA_TOKEN = "simula.token";
	public static final String TOKEN_PRUEBA = "token.prueba";
	public static final String TOKEN_PRUEBA_OLD = "token.prueba.old";

	// procedimientos
	public static final String PROCEDURE_ID_APERTURA = "procedureId.apertura";
	public static final String PROCEDURE_ID_OS2 = "procedureId.os2";
	public static final String PROCEDURE_ID_OS3 = "procedureId.os3";
	public static final String PROCEDURE_ID_PREFIX = "procedureId.";
	public static final String PROC_INFO_PROC_DESC_ES_PREFIX = "procedure.info.desc.es.";
	public static final String PROC_INFO_PROC_DESC_EU_PREFIX = "procedure.info.desc.eu.";

	public static final String DA_PROCEDURE_ID_APERTURA = "daprocedureId.apertura";
	public static final String DA_PROCEDURE_ID_OS2 = "daprocedureId.os2";
	public static final String DA_PROCEDURE_ID_OS3 = "daprocedureId.os3";

	// cargar información de procedimiento de properties (false = fdcdp)
	public static final String PROC_INFO_LOAD_PROPERTIES = "procedure.info.load.properties";

	// audit user usuario automático
	public static final String AUDIT_USER_AUTO = "audituser.auto";

	// pif
	public static final String PIF_TTL = "pif_ttl";
	public static final String PIF_RUTA_APP = "pif.ruta.app";
	public static final String PIF_RUTA_DOKUSI = "pif.ruta.dokusi";
	public static final String PIF_RUTA_PPS = "pif.ruta.pps";
	public static final String PIF_RUTA_PIF_DOKUSI = "pif.ruta.pifdokusi";

	// dokusi
	public static final String SERIE_DOCUMENTAL_DOKUSI_APERTURAS = "serie_documental_dokusi_aperturas";
	public static final String SERIE_DOCUMENTAL_DOKUSI_OS = "serie_documental_dokusi_os";
	public static final String ACL_DOKUSI = "acl_dokusi";

	// datos del órgano gestor
	public static final String ENTITY_ID = "entity.id";
	public static final String ENTITY_NAME = "entity.name";
	public static final String ORGANISM_ID = "organism.id";
	public static final String ORGANISM_NAME = "organism.name";
	public static final String DEPARTMENT_ID = "department.id";
	public static final String DEPARTMENT_NAME = "department.name";
	public static final String MANAGINGUNIT_ID = "managingunit.id";
	public static final String MANAGINGUNIT_NAME = "managingunit.name";
	public static final String FAMILY_ID = "family.id";
	public static final String FAMILY_NAME = "family.name";

	// datos de Osalan
	public static final String ORGANISM_OSALAN_ID = "organism.osalan.id";
	public static final String ORGANISM_OSALAN_NAME = "organism.osalan.name";
	public static final String DEPARTMENT_OSALAN_ID = "department.osalan.id";
	public static final String DEPARTMENT_OSALAN_NAME = "department.osalan.name";
	public static final String MANAGINGUNIT_OSALAN_ID = "managingunit.osalan.id";
	public static final String MANAGINGUNIT_OSALAN_NAME = "managingunit.osalan.name";

	// certificado de firma
	public static final String CERT_INSTANCE = "cert.instance.id";

	// textos de notificacion
	public static final String NOTTEXT_APERTURAS_REQSUB = "nottext.aperturas.reqsub";
	public static final String NOTTEXT_APERTURAS_COMUNIC_1 = "nottext.aperturas.comunic1";
	public static final String NOTTEXT_APERTURAS_COMUNIC_2 = "nottext.aperturas.comunic2";

	public static final String NOTTEXT_OS2_REQSUB = "nottext.os2.reqsub";
	public static final String NOTTEXT_OS2_COMUNIC = "nottext.os2.comunic";

	public static final String NOTTEXT_OS3_REQSUB = "nottext.os3.reqsub";
	public static final String NOTTEXT_OS3_COMUNIC = "nottext.os3.comunic";

	// servicio de correspondencia
	public static final String ENVIO_POSTAL_REMESA_DESCRIPCION = "envio.postal.remesa.descripcion";
	public static final String ENVIO_POSTAL_TELEFONO_DELEGACION = "delegacion.telefono.";

	// configuración reintentos cola
	public static final String NUM_REINTENTOS_JMS_AVISOS = "jms.avisos.reintentosmax";
	public static final String NUM_REINTENTOS_JMS_LIMITE = "jms.avisos.limitemax";

	public static final String URL_SUBIDA_DOCUMENTOS = "copia.autentica.urlADFileUpload.url";
	public static final String SIGNING_CERT_ID_APPLET = "certificado.firma.applet";
	public static final String JAVASCRIPT_RESULT = "javascript_result";

	public static final String URL_DESCARGA_APPLET = "url.descarga.applet";
	public static final String RUTA_PLANTILLA_EST_TEMP = "ruta.plantilla.est.temp";

	public static final String GESTION_ENVIOS_URL_AA66_REMESA = "gestionenvios.urlaa66.remesa";
	public static final String GESTION_ENVIOS_URL_AA66_COLECCION = "gestionenvios.urlaa66.coleccion";
	public static final String GESTION_ENVIOS_URL_AA66_ENVIO = "gestionenvios.urlaa66.envio";

	public static final String URL_CLIENTE_TRAMITACION = "url.cliente.tramitacion";

	private static Map<String, String> propertiesMap;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.springframework.beans.factory.config.PropertyPlaceholderConfigurer#
	 * processProperties(org.springframework.beans.factory.config.
	 * ConfigurableListableBeanFactory, java.util.Properties)
	 */
	@Override()
	protected void processProperties(
			ConfigurableListableBeanFactory beanFactory, Properties props)
			throws BeansException {

		super.processProperties(beanFactory, props);
		PropertiesUtil.propertiesMap = new HashMap<String, String>();

		for (Object key : props.keySet()) {

			String keyStr = key.toString();
			PropertiesUtil.propertiesMap.put(keyStr,
					this.resolvePlaceholder(keyStr, props));
		}
	}

	/**
	 * Gets the property.
	 * 
	 * name String String
	 *
	 * @param name
	 *            the name
	 * @return the property
	 */
	public static String getProperty(String name) {
		return PropertiesUtil.propertiesMap.get(name);
	}

}
